﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using System.IO;

using Tools.PdfProvider;

using LibraryText;
using LibraryText.Entities;

using Calibre.Model.Database;
using Calibre.Model.Database.Entities;
using Calibre.Model.Domain.Entities;
using Calibre.Model.Domain.Dal;

namespace Calibre.WebApi.Controllers
{
    [ApiController]
    [Route("[controller]")]
    public class BookController 
        : ControllerBase
    {
        private readonly SearchProvider SearchProvider;

        private static DirectoryInfo LibDirectory { set; get; }
            = new DirectoryInfo(@"S:\BooksText\Calibre");


        public BookController(
            SearchProvider searchProvider
            )
        {
            SearchProvider = searchProvider;
        }


        [HttpGet]
        public async Task<BookWithLibraryContainer[]> Get(
            int top = -1
            ) 
        {
            var libraries = Library.SearchAll(LibDirectory);

            var searchResult = await SearchProvider.GetBooksByLibrariesAsync(
                libraries: libraries
                )
                .ConfigureAwait(false);

            var allBooks = searchResult
                .SelectMany(e => e.Value)
                .ToArray();

            if (top > 0)
            {
                allBooks = allBooks
                    .Take(top)
                    .ToArray();
            }

            return allBooks;
        }
    }
}
