﻿using System;
using System.Collections.Generic;

#nullable disable

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace Calibre.Model.Database.Entities
{
    /// <summary>
    /// Файлы книги
    /// </summary>
    public partial class Data
    {
        public long Id { get; set; }

        public long Book { get; set; }
        public Book BookItem { get; set; }

        public string Format { get; set; }
        public long UncompressedSize { get; set; }
        public string Name { get; set; }


        internal static void EfSetup(
            EntityTypeBuilder<Data> entity
            )
        {
            entity.ToTable("data");

            entity.HasIndex(e => new { e.Book, e.Format }, "IX_data_book_format")
                .IsUnique();

            entity.HasIndex(e => e.Book, "data_idx");

            entity.HasIndex(e => e.Format, "formats_idx");

            entity.Property(e => e.Id)
                .ValueGeneratedNever()
                .HasColumnName("id");

            entity.Property(e => e.Book).HasColumnName("book");

            entity.Property(e => e.Format)
                .IsRequired()
                .HasColumnName("format");

            entity.Property(e => e.Name)
                .IsRequired()
                .HasColumnName("name");

            entity.Property(e => e.UncompressedSize).HasColumnName("uncompressed_size");


            entity.HasOne(e => e.BookItem)
                .WithMany(e => e.FileData)
                .HasForeignKey(e => e.Book);
        }
    }
}
