﻿using System;
using System.Collections.Generic;

#nullable disable

namespace Calibre.Model.Database.Entities
{
    public partial class Book
    {
        public long Id { get; set; }
        /// <summary>
        /// Заголовок
        /// </summary>
        public string Title { get; set; }
        public string Sort { get; set; }
        public byte[] Timestamp { get; set; }
        public byte[] Pubdate { get; set; }
        public double SeriesIndex { get; set; }
        public string AuthorSort { get; set; }
        public string Isbn { get; set; }
        public string Lccn { get; set; }
        /// <summary>
        /// Относительный путь к папке с файлами книги
        /// </summary>
        public string Path { get; set; }
        public long Flags { get; set; }
        public string Uuid { get; set; }
        public byte[] HasCover { get; set; }
        public byte[] LastModified { get; set; }

        public virtual List<BooksTagsLink> Tags { get; set; } 
            = new List<BooksTagsLink>();
        public virtual List<BooksAuthorsLink> Autors { get; set; }
            = new List<BooksAuthorsLink>();
        public virtual List<Data> FileData { get; set; }
            = new List<Data>();


        public override string ToString()
        {
            return $"{Id}.{Title}";
        }
    }
};
