﻿using System;
using System.IO;
using System.Threading.Tasks;

using Calibre.Model.Database.Entities;

namespace Calibre.Model.Database
{
    public class BookFileProvider
    {
        public async Task<string> BuildFilePathAsync(
            string bookDirectory,
            Book book,
            Func<Book, Task<Data>> fileSelectorActionAsync
            )
        {
            var file = await fileSelectorActionAsync(book);

            var filePath = Path.Combine(
                bookDirectory,
                book.Path.Replace('/', '\\'),
                $"{file.Name}.{file.Format}"
                );

            return filePath;
        }

        public async Task ReadFileAsync(
            string bookDirectory,
            Book book,
            Func<Book, Task<Data>> fileSelectorActionAsync,
            Func<Stream, Task> readActionAsync
            )
        {
            var filePath = await BuildFilePathAsync(
                bookDirectory,
                book,
                fileSelectorActionAsync
                );

            using (var stream = new FileStream(filePath, FileMode.Open))
            {
                await readActionAsync(stream);
            }
        }

        public async Task<T> ReadFileAsync<T>(
            string bookDirectory,
            Book book,
            Func<Book, Task<Data>> fileSelectorActionAsync,
            Func<Stream, Task<T>> readActionAsync
            ) 
        {
            var filePath = await BuildFilePathAsync(
                bookDirectory, 
                book, 
                fileSelectorActionAsync
                );

            using (var stream = new FileStream(filePath, FileMode.Open))
            {
                var result = await readActionAsync(stream);
                return result;
            }
        }        
    }
}
