﻿using System;
using System.Collections.Generic;

#nullable disable

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace Calibre.Model.Database.Entities
{
    public partial class BooksAuthorsLink
    {
        public long Id { get; set; }              

        public long Book { get; set; }
        public virtual Book BookItem { get; set; }

        public long Author { get; set; }
        public virtual Author AuthorItem { get; set; }


        public override string ToString()
        {
            return $"{Author}|{AuthorItem?.Name}|{Book}|{BookItem?.Title}";
        }


        internal static void EfSetup(
            EntityTypeBuilder<BooksAuthorsLink> entity
            )
        {
            entity.ToTable("books_authors_link");

            entity.HasIndex(e => new { e.Book, e.Author }, "IX_books_authors_link_book_author")
                .IsUnique();

            entity.HasIndex(e => e.Author, "books_authors_link_aidx");

            entity.HasIndex(e => e.Book, "books_authors_link_bidx");

            entity.Property(e => e.Id)
                .ValueGeneratedNever()
                .HasColumnName("id");

            entity.Property(e => e.Author).HasColumnName("author");

            entity.Property(e => e.Book).HasColumnName("book");


            entity
                .HasOne(e => e.BookItem)
                .WithMany(e => e.Autors)
                .HasForeignKey(e => e.Book);
            entity
                .HasOne(e => e.AuthorItem)
                .WithMany(e => e.Books)
                .HasForeignKey(e => e.Author);
        }
    }
}
