﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tools.PdfProvider
{
    public class ImmutableProxy<T>
    {
        public T Data { private set; get; }


        public ImmutableProxy(T data)
        {
            Data = data;
        }
        public static ImmutableProxy<T> Create(T data)
        {
            return new ImmutableProxy<T>(data);
        }


        public ImmutableProxy<T> MutateValue(Func<T, T> mutateFunc)
        {
            Data = mutateFunc(Data);
            return this;
        }


        #region override

        public override bool Equals(object obj)
        {
            return Data.Equals(obj);
        }

        public override int GetHashCode()
        {
            return Data.GetHashCode();
        }

        public override string ToString()
        {
            return Data.ToString();
        }

        #endregion

        public static implicit operator T(ImmutableProxy<T> proxy)
        {
            return proxy.Data;
        }
    }
}
