﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using System.IO;

using Microsoft.AspNetCore.Components;

using Calibre.Model.Domain.Entities;
using Calibre.Model.Domain.Dal;

using Calibre.App.BlazorUI.ViewModels;

namespace Calibre.App.BlazorUI.Pages
{
    public partial class Index 
    {
        private static DirectoryInfo LibDirectory { set; get; }
            = new DirectoryInfo(@"S:\BooksText\Calibre");


        [Inject]
        private SearchProvider SearchProvider { set; get; }

        private BookViewModel Model { set; get; }
            = new BookViewModel();


        #region

        protected override async Task OnInitializedAsync()
        {
            if (Model.AllBooks.Length != 0)
            {
                return;
            }

            var libraries = Library.SearchAll(LibDirectory);

            var searchResult = await SearchProvider.GetBooksByLibrariesAsync(
                libraries: libraries
                )
                .ConfigureAwait(false);

            var allBooks = searchResult
                .SelectMany(e => e.Value)
                .ToArray();

            Model.AllBooks = allBooks;
            Model.VisibleBooks = allBooks;
        }

        #endregion


        #region UiEvents

        private Task OnSearchButtonClickAsync() 
        {
            if (string.IsNullOrWhiteSpace(Model.SearchInput))
            {
                Model.VisibleBooks = Model.AllBooks;
                return Task.CompletedTask;
            }

            var stringComparer = StringComparison.OrdinalIgnoreCase;

            Model.VisibleBooks = Model
                .AllBooks
                .Where(
                    e => 
                        e.Book.Title.Contains(Model.SearchInput, stringComparer)
                        || e.Book.Autors.Any(e2 => e2.AuthorItem.Name.Contains(Model.SearchInput, stringComparer))
                        || e.Book.Tags.Any(e2 => e2.TagItem.Name.Contains(Model.SearchInput, stringComparer))
                        )
                .ToArray();

            return Task.CompletedTask;
        }

        #endregion
    }
}
