﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using IronPython.Hosting;
using Microsoft.Scripting.Hosting;

using System.IO;

namespace TryIronPython
{
    class Program
    {


        /// <summary>
        /// Выпонение из строки
        /// </summary>
        static void Example1()
        {
            ScriptEngine engine = Python.CreateEngine();
            engine.Execute("print 'hello, world'");
        }

        /// <summary>
        /// ВЫполнение из файла
        /// </summary>
        static void Example2()
        {
            ScriptEngine engine = Python.CreateEngine();
            engine.ExecuteFile(@"Python\Example2.py");
        }


        /// <summary>
        /// Выполнение из файла
        /// Получение и задание переменных скрипта
        /// </summary>
        static void Example3()
        {
            int yNumber = 22;

            ScriptEngine engine = Python.CreateEngine();
            ScriptScope scope = engine.CreateScope();

            scope.SetVariable("y", yNumber);
            engine.ExecuteFile(@"Python\Example3.py", scope);

            dynamic xNumber = scope.GetVariable("x");
            dynamic zNumber = scope.GetVariable("z");

            Console.WriteLine("Сумма {0} и {1} равна: {2}", xNumber, yNumber, zNumber);
        }


        /// <summary>
        /// Выполнение из файла
        /// Получение и вызов функции
        /// </summary>
        static void Example4()
        {
            int x = 5;

            ScriptEngine engine = Python.CreateEngine();
            ScriptScope scope = engine.CreateScope();

            engine.ExecuteFile(@"Python\Example4.py", scope);
            dynamic function = scope.GetVariable("factorial");

            // вызываем функцию и получаем результат
            dynamic result = function(x);
            Console.WriteLine(string.Format("Факторил({0}) = {1}", x, result));
        }


        /// <summary>
        /// Выполнение из файла
        /// Работа с модулями
        /// 
        /// Насколько понял нужны полные пути
        /// Подпапки не учитываются
        /// </summary>
        static void Example5()
        {
            DirectoryInfo LibDir = 
                new DirectoryInfo(@"Python\Lib");

            var LibsDir = new List<string>
                (
                //LibDir.GetDirectories().
                //Select(e => e.FullName).
                //Concat(new string[] { LibDir.FullName})
                )
            {              @".\Python\Lib"};

            ScriptEngine engine = Python.CreateEngine();
            //engine.SetSearchPaths(LibsDir);

            engine.ExecuteFile(@"Python\Example5.py");
        }



        /// <summary>
        /// Попытка использовать сторонние модули
        /// Стандартный модули IronPython.Std
        /// 
        /// </summary>
        static void Example6()
        {
            ScriptEngine engine = Python.CreateEngine();
            var l = engine.GetSearchPaths();

            DirectoryInfo LibDir =
    new DirectoryInfo(@"Python\Lib");

            var LibsDir = new List<string>
                (
                LibDir.GetDirectories("*", SearchOption.AllDirectories).
                Select(e => e.FullName).
                Concat(new string[] { LibDir.FullName })
                );
            engine.SetSearchPaths(LibsDir);
            engine.ExecuteFile(@"Python\Example6.py");
        }

        static void Main(string[] args)
        {
            Example5();

            Console.ReadKey();
        }
    }
}
