﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;
using System.Xml.Serialization;

using RW_Tool.Interface.Actions;
using RW_Tool.DataSource.FileOrStream;

namespace ConfigurationTool.Serializer.XML
{
    public class XML_Reader<T> : IReader<T, DS_FileOrStream>
        where T : class, new()
    {
        public T Read(DS_FileOrStream ds)
        {
            switch (ds.Type)
            {
                case "File": return ReadFile(ds.AsFile.FilePath);
                case "Stream": return ReadStream(ds.AsStream.Stream);

                default: throw new Exception();
            }
        }

        public T ReadFile(string file)
        {
            // передаем в конструктор тип класса
            XmlSerializer formatter = new XmlSerializer(typeof(T));

            // десериализация
            using (FileStream fs = new FileStream(file, FileMode.Open))
            {
                return (T)formatter.Deserialize(fs);
            }
        }
        public T ReadStream(Stream stream)
        {
            // передаем в конструктор тип класса
            XmlSerializer formatter = new XmlSerializer(typeof(T));

            // десериализация
            return (T)formatter.Deserialize(stream);
        }
    }
}
