﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using SingletonTool;

namespace ConfigurationTool.ConfigMultiple.Custom
{      
    //Обеспечивате доступ к конфигу
    public sealed class MConfigurationManager<T1, T2>
        where T1: class, new()
        where T2 : class, new()
    {
        //Конфиг
        private MConfigEntity<T1, T2> Config => SignlethonWithParams<MConfigEntity<T1, T2>, MConfigParams<T1, T2>>.Get();
        //Данные конфига
        public Dictionary<string, T1> Data
        {
            set => Config.Data = value;
            get => Config.Data;
        }

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public MConfigurationManager(MConfigParams<T1, T2> param)
        {
            if (!SignlethonWithParams<MConfigEntity<T1,T2>, MConfigParams<T1,T2>>.ExistInstance)
                SignlethonWithParams<MConfigEntity<T1, T2>, MConfigParams<T1, T2>>.Create(param);
        }

        //Для повторных обращений к конфигу
        public MConfigurationManager()
        {
            if (!SignlethonWithParams<MConfigEntity<T1, T2>, MConfigParams<T1, T2>>.ExistInstance)
                throw new Exception("Use ConfigurationManager(ConfigParams param) first");
        }


        public void Add(string key, T1 value)
        {
            Data.Add(key, value);
            Config.Export(key);
        }
        public void Remove(string key)
        {
            Data.Remove(key);
            var path = Config.Params.GetPathForFile(key);
            if (File.Exists(path))
                File.Delete(path);
        }

        //Прочитать из файла
        public void Import()
        {
            Config.ImportAll();
        }
        //Сохранить в файл
        public void Export()
        {
            Config.ExportAll();
        }

        public void Delete()
        {
            var dir = Config.Params.ConfigDirectoryInfo;

            if (dir.Exists)
                dir.Delete(true);
        }
    }
}
