﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Test_ConfigurationTool.Entities
{
    public class Config1
    {
        public int IntProperty { set; get; }
        public string StringProperty { set; get; }
        
        public List<string> ListProperty { set; get; }

        public static Config1 GetConfig_1() =>
            new Config1()
            {
                IntProperty = 10,
                StringProperty = "10",
                ListProperty = new List<string>()
                {
                   "A10",
                   "B20"
                }
            };

        public static bool operator ==(Config1 c1, Config1 c2)
        {
            if (c1.IntProperty != c2.IntProperty)
                return false;

            if (c1.StringProperty != c2.StringProperty)
                return false;

            if (c1.ListProperty.Count != c2.ListProperty.Count)
                return false;

            for (int i = 0; i < c1.ListProperty.Count; i++)
                if (c1.ListProperty[i] != c2.ListProperty[i])
                    return false;

            return true;
        }
        public static bool operator !=(Config1 c1, Config1 c2)
        {
            return !(c1 == c2);
        }
    }
}
