﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using SingletonTool;

namespace ConfigurationTool.Config.Custom
{      
    //Обеспечивате доступ к конфигу
    public sealed class ConfigurationManager<T1, T2>
        where T1: class, new()
        where T2 : class, new()
    {
        //Конфиг
        private ConfigEntity<T1, T2> Config => SignlethonWithParams<ConfigEntity<T1, T2>, ConfigParams<T1, T2>>.Get();
        //Данные конфига
        public T1 Data
        {
            set => Config.Data = value;
            get => Config.Data;
        }

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public ConfigurationManager(ConfigParams<T1,T2> param)
        {
            if (!SignlethonWithParams<ConfigEntity<T1,T2>, ConfigParams<T1,T2>>.ExistInstance)
                SignlethonWithParams<ConfigEntity<T1,T2>, ConfigParams<T1, T2>>.Create(param);
        }

        //Для повторных обращений к конфигу
        public ConfigurationManager()
        {
            if (!SignlethonWithParams<ConfigEntity<T1>, ConfigParams>.ExistInstance)
                throw new Exception("Use ConfigurationManager(ConfigParams param) first");
        }


        //Прочитать из файла
        public void Import()
        {
            Config.Import();
        }
        //Сохранить в файл
        public void Export()
        {
            Config.Export();
        }

        public bool Exist() => File.Exists(Config.Params.ConfigPath);
        public void Delete()
        {
            if (Exist())
                File.Delete(Config.Params.ConfigPath);
        }
    }
}
