﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using RW_Tool;
using RW_Tool.Interface;
using RW_Tool.Interface.Custom;
using RW_Tool.DataSource.FileOrStream;

using ConfigurationTool.Serializer.XML;
using ConfigurationTool.Serializer.Bin;

namespace ConfigurationTool.Serializer
{
    internal class SerializerFactory       
    {
        public I_RWI<T, DS_FileOrStream> GetSerializer<T>(string file, EnumFormat format)
            where T : class, new()
        {
            switch (format)
            {
                case EnumFormat.XML:
                    return new RWI<T, DS_FileOrStream>(
                        new DS_File(file),
                        new XML_Reader<T>(),
                        new XML_Writer<T>()
                    );

                case EnumFormat.Binary:
                    return new RWI<T, DS_FileOrStream>(
                        new DS_File(file),
                        new Bin_Reader<T>(),
                        new Bin_Writer<T>()
                    );
            }

            throw new Exception();
        }
        public I_RWI<T1, DS_FileOrStream> GetSerializer_Custon<T1,T3>(string file, EnumFormat format, ITransformator<T1,T3> transformator)
            where T1: class, new()
            where T3: class, new()
        {
            switch (format)
            {
                case EnumFormat.XML:
                    return new RWI_Custom<T1, DS_FileOrStream, T3>(
                        new DS_File(file),
                        transformator,
                        new XML_Reader<T3>(),
                        new XML_Writer<T3>()
                    );

                case EnumFormat.Binary:
                    return new RWI_Custom<T1, DS_FileOrStream, T3>(
                        new DS_File(file),
                        transformator,
                        new Bin_Reader<T3>(),
                        new Bin_Writer<T3>()
                    );
            }

            throw new Exception();
        }

    }
}
