﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

using ConfigurationTool.CustomSerializer;

using RW_Tool;
using RW_Tool.DataSource.FileOrStream;

using RW_Tool.Interface;
using ConfigurationTool.RW.Bin;

namespace ConfigurationTool.Serializer
{
    class BinarySerializer<T>
        :
        RWI<T, DS_FileOrStream>,
        ISerializer<T>
        where T : class, new()
    {
        public BinarySerializer(string file) : base(new DS_File() { FilePath = file })
        {
            Reader = new Bin_Reader<T>();
            Writer = new Bin_Writer<T>();
        }
        public BinarySerializer(Stream stream) : base(new DS_Stream() { Stream = stream })
        {
            Reader = new Bin_Reader<T>();
            Writer = new Bin_Writer<T>();
        }

        public T Read()
            => Reader.Read(DataStorage);

        public void Write(T entity)
            => Writer.Write(entity, DataStorage);
    }
}
