﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Xml.Serialization;

using RW_Tool;
using RW_Tool.DataSource.FileOrStream;
using ConfigurationTool.RW.XML;

namespace ConfigurationTool.Serializer
{
    class XMLSerializer<T>
        : 
        RWI<T, DS_FileOrStream>,
        ISerializer<T>
        where T : class, new()
    {
        
        public XMLSerializer(string file) : base(new DS_File() { FilePath = file })
        {
            Reader = new XML_Reader<T>();
            Writer = new XML_Writer<T>();
        }
        public XMLSerializer(Stream stream) : base(new DS_Stream() { Stream = stream })
        {
            Reader = new XML_Reader<T>();
            Writer = new XML_Writer<T>();
        }

        public T Read()
            => Reader.Read(DataStorage);

        public void Write(T entity)
            => Writer.Write(entity, DataStorage);
    }
}
