﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;

using RW_Tool.DataSource;

namespace RW_Tool.DataSource.FileOrStream
{
    public abstract class DS_FileOrStream : DS_Base
    {
        public DS_File AsFile => (DS_File)this;
        public bool IsFile => this is DS_File;

        public DS_Stream AsStream => (DS_Stream)this;
        public bool IsStream => this is DS_Stream;
    }

    public class DS_File: DS_FileOrStream
    {
        public override string Type => "File";

        public string FilePath { set; get; }
        public FileInfo FileInfo => new FileInfo(FilePath);
    }
    public class DS_Stream: DS_FileOrStream
    {
        public override string Type => "Stream";

        public Stream Stream { set; get; }        
    }
}
