﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using Tools.ConfigurationTool.ConfigMultiple.Base;

namespace Tools.ConfigurationTool.ConfigMultiple
{
    //Singlethon сущность конфига 
    internal class MConfigEntity<T>
        : BaseMConfigEntity<T, MConfigParams>
        where T : class, new()
    {

        public override void SetParams(MConfigParams param)
        {
            base.SetParams(param);

            if (Directory.Exists(Params.ConfigDirectoryPath))
            {
                ImportAll();
            }
            ExportAll();
        }

        protected override T Read(string path)
        {
            return Params.RW_Factory
                .Get_RW<T>(path, Params.Format)
                .Read();
        }

        protected override void Write(T data, string key)
        {
            Params.RW_Factory
                .Get_RW<T>(Params.GetPathForFile(key), Params.Format)
                .Write(data);
        }
    }
}
