﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Tools.SingletonTool.Base;


namespace Tools.SingletonTool.Manager
{
    /// <summary>
    /// Синглтон с параметром создания
    /// </summary>
    /// <typeparam name="T">Тип синглот</typeparam>
    /// <typeparam name="P">Тип параметра</typeparam>
    public class SinglethonWithParamsManager<T, P>
        : ISignlethonManager<T>
        where T : class, ISignlethonWithParams<P>, new()
    {
        private static P Param;
        private static bool IsParamSet = false;

        private static readonly Lazy<T> Single
            = new Lazy<T>(() => {
                if (!IsParamSet)
                {
                    throw new Exception("Instance not create. Use SignlethonWithParamsManager(P param) first");
                }

                T single = new T();
                single.SetParams(Param);
                Param = default(P);

                return single;
            }, 
                true);


        public SinglethonWithParamsManager() 
        {            
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="param">Параметры для создания экземпляра. Not null</param>
        public SinglethonWithParamsManager(P param) 
        {
            //Возможно добавить синхронность
            if (!IsParamSet)
            {
                Param = param;
                IsParamSet = true;
            }
        }

        public T Get
            => Single.Value;

        public bool ExistInstance
            => Single.IsValueCreated;

    }
}
