﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.SingletonTool.Manager;

using Tools.ConfigurationTool.Config.Base;

namespace Tools.ConfigurationTool.Config
{
    /// <summary>
    /// Обеспечивает доступ к конфигу
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class ConfigurationManager<T>
        where T: class, new()
    {
        private SinglethonWithParamsManager<ConfigEntity<T>, ConfigParams> SinglethonManager;

        internal virtual IConfigEntity<T> ConfigEntity => SinglethonManager.Get;

        //Данные конфига
        public T Data
        {
            set => ConfigEntity.Data = value;
            get => ConfigEntity.Data;
        }

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public ConfigurationManager(ConfigParams param)
        {
            SinglethonManager = 
                new SinglethonWithParamsManager<ConfigEntity<T>, ConfigParams>(param);            
        }

        //Для повторных обращений к конфигу
        public ConfigurationManager()
        {
            SinglethonManager = 
                new SinglethonWithParamsManager<ConfigEntity<T>, ConfigParams>();
        }


        /// <summary>
        /// Прочитать из файла
        /// </summary>
        public void Import()
        {
            ConfigEntity.Import();
        }
        /// <summary>
        /// Сохранить в файл
        /// </summary>
        public void Export()
        {
            ConfigEntity.Export();
        }


        public bool FileExist()
        {
            return ConfigEntity.FileExist();
        }
        public void Delete()
        {
            ConfigEntity.DeleteFile();
        }

    }

}
