﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Diagnostics;

namespace Tools.SimpleBenchmark
{
    //Тестер для проверки времениработы
    public class TimeTester
    {
        /// <summary>
        /// Функция проверка времени выполнения
        /// </summary>
        /// <param name="TestCount">Кол-во тестовых запусков</param>
        /// <param name="action">Задание для проверки</param>
        /// <param name="Preheating">Выполнить предварительный тестовый запуск делегата</param>
        /// <returns></returns>
        public TimeTestResult Work(int TestCount, Action action, bool Preheating = true)
        {
            if (Preheating)
                action();

            TimeTestResult res = new TimeTestResult(TestCount);

            Stopwatch stopwatch = new Stopwatch();

            for (int i = 0; i < TestCount; i++)
            {

                stopwatch.Start();
                action();
                stopwatch.Stop();

                res[i] = new WorkTime(stopwatch);

                stopwatch.Reset();
            }


            return res;
        }

    }
}
