﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using RW_Tool;
using RW_Tool.DataSource.FileOrStream;

using ConfigurationTool.Serializer;
using SingletonTool;

namespace ConfigurationTool.ConfigMultiple
{
    //Singlethon сущность конфига 
    public class ConfigEntity<T>
        : ISignlethonWithParams<ConfigParams>
        where T : class, new()
    {
        //Параметры конфига
        public ConfigParams Params { private set; get; }

        //Объект сериализации
        private ISerializer<T> Serializer;

        //Данные, хранимые в конфиге
        public Dictionary<string, T> Data { set; get; } = new Dictionary<string, T>();


        public void SetParams(ConfigParams param)
        {
            Params = param;

            switch (param.Format)
            {
                case EnumFormat.XML: Serializer = new XMLSerializer<T>(Params.ConfigDirectoryPath); break;
                case EnumFormat.Binary: Serializer = new BinarySerializer<T>(Params.ConfigDirectoryPath); break;
            }

            if (Directory.Exists(Params.ConfigDirectoryPath))
                ImportAll();
            ExportAll();
        }





        public void Export(string key)
        {
            Serializer.Writer.Write(
                Data[key], 
                new DS_File() { FilePath = Params.GetPathForFile(key) }
            );
        }
        public void ExportAll()
        {
            DirectoryInfo dir = Params.ConfigDirectoryInfo;

            if (Params.RecreateDirectory)
            {
                if (dir.Exists)
                    dir.Delete(true);
            }
            dir.Refresh();
            if (!dir.Exists)
                dir.Create();

            foreach (var elem in Data)
                Export(elem.Key);
        }

        public void Import(string path)
        {
            Data.Add(
                Path.GetFileNameWithoutExtension(Path.GetFileName(path)),
                Serializer.Reader.Read(new DS_File() { FilePath = path})
                );
        }
        public void ImportAll()
        {
            DirectoryInfo dir = Params.ConfigDirectoryInfo;

            if (!dir.Exists)
            {
                dir.Create();
                return;
            }

            var data = dir.GetFiles();

            foreach (var elem in data)
            {
                Import(elem.FullName);
            }
        }
    }
}
