﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using SingletonTool;

namespace ConfigurationTool.ConfigMultiple
{      
    //Обеспечивате доступ к конфигу
    public sealed class ConfigurationManager<T>
        where T: class, new()
    {
        //Конфиг
        private ConfigEntity<T> Config => SignlethonWithParams<ConfigEntity<T>, ConfigParams>.Get();
        //Данные конфига
        public Dictionary<string,T> Data => Config.Data;

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public ConfigurationManager(ConfigParams param)
        {
            if (!SignlethonWithParams<ConfigEntity<T>, ConfigParams>.ExistInstance)
                SignlethonWithParams<ConfigEntity<T>, ConfigParams>.Create(param);
        }

        //Для повторных обращений к конфигу
        public ConfigurationManager()
        {
            if (!SignlethonWithParams<ConfigEntity<T>, ConfigParams>.ExistInstance)
                throw new Exception("Use ConfigurationManager(ConfigParams param) first");
        }


        public void Add(string key, T value)
        {
            Data.Add(key, value);
            Config.Export(key);
        }
        public void Remove(string key)
        {
            Data.Remove(key);
            var path = Config.Params.GetPathForFile(key);
            if (File.Exists(path))
                File.Delete(path);
        }

        //Прочитать из файла
        public void Import()
        {
            Config.ImportAll();
        }
        //Сохранить в файл
        public void Export()
        {
            Config.ExportAll();
        }

    }
}
