﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Windows.Forms;

namespace ConfigurationTool.ConfigMultiple
{
    public enum EnumFormat
    {
        XML,
        Binary
    }

    //Базовые параметры конфига
    public class ConfigParams
    {
        //Папка, в которой будут храниться конфиги
        public string ConfigDirectory { set; get; }
        //Флаг: испоьзовать ли в пути к файлу путь к .exe приложению
        public bool UseApplicationPathPrefix { set; get; } = true;

        //Формат в котором будет храниться конфиг
        public EnumFormat Format { set; get; } = EnumFormat.XML;

        //Пересоздавать папку при общем сохранении
        public bool RecreateDirectory { set; get; } = true;

        //Полный путь к конфигу
        public string ConfigDirectoryPath => (UseApplicationPathPrefix
            ?
             Path.Combine(Application.StartupPath, ConfigDirectory)
            :
             ConfigDirectory
            );
        public DirectoryInfo ConfigDirectoryInfo => new DirectoryInfo(ConfigDirectoryPath);


        public string GetPathForFile(string key) =>        
             Path.Combine(ConfigDirectoryPath, key + 
                (Format == EnumFormat.XML ? ".xml" : ".bin")
                );        
    }
}
