﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using RW_Tool;
using RW_Tool.DataSource.FileOrStream;

using ConfigurationTool.Serializer;
using SingletonTool;

using RW_Tool.Interface;

using ConfigurationTool.Config;

namespace ConfigurationTool.Config.Custom
{

    internal class ConfigEntity<T1, T2>
        : ISignlethonWithParams<ConfigParams<T1, T2>>
        where T1 : class, new()
        where T2 : class, new()
    {
        //Параметры конфига
        public ConfigParams<T1, T2> Params { private set; get; }

        //Объект сериализации
        I_RWI<T1, DS_FileOrStream> Serializer;


        //Данные, хранимые в конфиге
        public T1 Data { set; get; } = new T1();

        public void SetParams(ConfigParams<T1, T2> param)
        {
            Params = param;

            Serializer = new SerializerFactory()
               .GetSerializer_Custon<T1, T2>(
               param.ConfigPath,
               param.Format,
               param.Transformator
               );

            if (File.Exists(Params.ConfigPath))
                Import();
            Export();
        }

        //Прочитать файл
        public void Import()
        {
            Data = Serializer.Read();
        }
        //Сохранить в файл
        public void Export()
        {
            Serializer.Write(Data);
        }
    }

}
