﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

using RW_Tool.Interface.Actions;
using RW_Tool.DataSource.FileOrStream;

namespace ConfigurationTool.Serializer.Bin
{
    public class Bin_Reader<T> : IReader<T, DS_FileOrStream>
        where T : class, new()
    {
        public T Read(DS_FileOrStream ds)
        {
            switch (ds.Type)
            {
                case "File": return ReadFile(ds.AsFile.FilePath);
                case "Stream": return ReadStream(ds.AsStream.Stream);

                default: throw new Exception();
            }
        }

        public T ReadFile(string file)
        {
            // передаем в конструктор тип класса
            BinaryFormatter formatter = new BinaryFormatter();

            // десериализация
            using (FileStream fs = new FileStream(file, FileMode.Open))
            {
                return (T)formatter.Deserialize(fs);
            }
        }
        public T ReadStream(Stream stream)
        {
            // передаем в конструктор тип класса
            BinaryFormatter formatter = new BinaryFormatter();

            // десериализация                
            return (T)formatter.Deserialize(stream);
        }
    }
}
