﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using RW_Tool;
using RW_Tool.DataSource.FileOrStream;

using ConfigurationTool.Serializer;
using SingletonTool;

using RW_Tool.Interface;

namespace ConfigurationTool.Config
{
    //Singlethon сущность конфига 
    internal class ConfigEntity<T>
        : ISignlethonWithParams<ConfigParams>
        where T : class, new()
    {
        //Параметры конфига
        internal ConfigParams Params { private set; get; }

        //Объект сериализации
        I_RWI<T, DS_FileOrStream> Serializer;

        //Данные, хранимые в конфиге
        public T Data { set; get; } = new T();

        public void SetParams(ConfigParams param)
        {
            Params = param;

           Serializer = new SerializerFactory()
                .GetSerializer<T>(Params.ConfigPath, param.Format);            

            if (File.Exists(Params.ConfigPath))
                Import();
            Export();
        }

        //Прочитать файл
        public void Import()
        {
            Data = Serializer.Read();
        }
        //Сохранить в файл
        public void Export()
        {
            Serializer.Write(Data);
        }
    }

}
