﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

using RW_Tool.Interface.Actions;
using RW_Tool.DataSource.FileOrStream;

namespace ConfigurationTool.Serializer.Bin
{ 
    public class Bin_Writer<T> : IWriter<T, DS_FileOrStream>
    {
        public void Write(T entity, DS_FileOrStream ds)
        {
            switch (ds.Type)
            {
                case "File": WriteFile(entity, ds.AsFile.FilePath); return;
                case "Stream": WriteStream(entity, ds.AsStream.Stream); return;

                default: throw new Exception();
            }
        }

        public void WriteFile(T entity, string file)
        {
            // передаем в конструктор тип класса
            BinaryFormatter formatter = new BinaryFormatter();

            // получаем поток, куда будем записывать сериализованный объект
            using (FileStream fs = new FileStream(file, FileMode.Create))
            {
                formatter.Serialize(fs, entity);
            }
        }
        public void WriteStream(T entity, Stream stream)
        {
            // передаем в конструктор тип класса
            BinaryFormatter formatter = new BinaryFormatter();

            formatter.Serialize(stream, entity);
        }
    }
}

