﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;

using Tools.SingletonTool.Base;

namespace Tools.ConfigurationTool.Config.Base
{
    
    internal abstract class BaseConfigEntity<D, P>
        : IConfigEntity<D>,
        ISignlethonWithParams<P>
        where D : class, new()
        where P : ConfigParams
    {
        /// <summary>
        /// Параметры конфига
        /// </summary>
        protected P Params { private set; get; }

        /// <summary>
        /// Данные, хранимые в конфиге
        /// </summary>
        public D Data { set; get; } = new D();


        public virtual void SetParams(P param)
        {
            Params = param;

            //if (File.Exists(Params.ConfigPath))
            //{
            //    Import();
            //}
            //Export();
        }



        protected abstract D Read();
        protected abstract void Write(D data);


        /// <summary>
        /// Прочитать файл
        /// </summary>
        public virtual void Import() 
        {
            Data = Read();
        }

        /// <summary>
        /// Сохранить в файл
        /// </summary>
        public virtual void Export() 
        {
            Write(Data);
        }

        public bool FileExist() => File.Exists(Params.ConfigPath);
        public void DeleteFile()
        {
            if (FileExist())
            {
                File.Delete(Params.ConfigPath);
            }
        }

    }
}
