﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.SingletonTool.Manager;
using Tools.ConfigurationTool.Config.Base;

namespace Tools.ConfigurationTool.Config.Custom
{      
    //Обеспечивате доступ к конфигу
    public sealed class ConfigurationManager<T1, T2> : ConfigurationManager<T1>
        where T1: class, new()
        where T2 : class, new()
    {
        private readonly SinglethonWithParamsManager<ConfigEntity<T1, T2>, ConfigParams<T1, T2>> SinglethonManager
            = new SinglethonWithParamsManager<ConfigEntity<T1, T2>, ConfigParams<T1, T2>>();

        internal override IConfigEntity<T1> ConfigEntity => SinglethonManager.Get;

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public ConfigurationManager(ConfigParams<T1,T2> param)
        {
            SinglethonManager
                = new SinglethonWithParamsManager<ConfigEntity<T1, T2>, ConfigParams<T1, T2>>(param);
        }

        //Для повторных обращений к конфигу
        public ConfigurationManager()
        {
            SinglethonManager
                = new SinglethonWithParamsManager<ConfigEntity<T1, T2>, ConfigParams<T1, T2>>();
        }
    }
}
