﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using RW_Tool.Core.Abstract;
using RW_Tool.DataSource.FileOrStream;
using RW_Tool.XML_BIN;

namespace Tools.ConfigurationTool.Serializer
{
    internal class SerializerFactory       
    {
        public I_RW<T, DS_FileOrStream> GetSerializer<T>(string file, EnumFormat format)
            where T : class, new()
        => new Factory<T>().GetRW(format, new DS_File(file));

        public I_RW<T1, DS_FileOrStream> GetSerializer_Custon<T1, T3>(string file, EnumFormat format, ITransformator<T1, T3> transformator)
            where T1 : class, new()
            where T3 : class, new()
        => new Factory<T1, T3>().GetRW(format, transformator, new DS_File(file));

    }
}
