﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Tools.SingletonTool.Base;

namespace Tools.SingletonTool.Manager
{
    /// <summary>
    /// Синглтон
    /// </summary>
    /// <typeparam name="T">Тип синглот</typeparam>
    public class SinglethonManager<T> 
        : ISignlethonManager<T>
        where T : class, new()
    {
        private static readonly Lazy<T> Single 
            = new Lazy<T>(() => { 
                return new T(); 
            }, 
                true);


        public T Get 
            => Single.Value;

        public bool ExistInstance 
            => Single.IsValueCreated;

    }
}
