﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.ConfigurationTool.ConfigMultiple.Base;

namespace Tools.ConfigurationTool.ConfigMultiple.Custom
{
    //Singlethon сущность конфига 
    public class MConfigEntity<T1, T2>
        : BaseMConfigEntity<T1, MConfigParams<T1, T2>>
        where T1 : class, new()
        where T2 : class, new()
    {
        protected override T1 Read(string path)
        {
            return Params.RW_Factory
                .Get_RW<T1, T2>(path, Params.Format, Params.Transformator)
                .Read();
        }

        protected override void Write(T1 data, string key)
        {
            Params.RW_Factory
                .Get_RW<T1, T2>(Params.GetPathForFile(key), Params.Format, Params.Transformator)
                .Write(data);
        }
    }
}
