﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.SingletonTool.Manager;

using Tools.ConfigurationTool.ConfigMultiple.Base;

namespace Tools.ConfigurationTool.ConfigMultiple
{      
    //Обеспечивате доступ к конфигу
    public class MConfigurationManager<T>
        where T: class, new()
    {
        private readonly SinglethonWithParamsManager<MConfigEntity<T>, MConfigParams> SinglethonManager;

        //Конфиг
        internal virtual IMConfigEntity<T> ConfigEntity => SinglethonManager.Get;
        
        public Dictionary<string, T> Data
        {
            set => ConfigEntity.Data = value;
            get => ConfigEntity.Data;
        }

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public MConfigurationManager(MConfigParams param)
        {
            SinglethonManager
                = new SinglethonWithParamsManager<MConfigEntity<T>, MConfigParams>(param);
        }

        //Для повторных обращений к конфигу
        public MConfigurationManager()
        {
            SinglethonManager
                = new SinglethonWithParamsManager<MConfigEntity<T>, MConfigParams>();
        }


        public void AddAndSave(string key, T value)
        {
            ConfigEntity.AddAndSave(key, value);
        }
        public void RemoveAndSave(string key)
        {
            ConfigEntity.RemoveAndSave(key);
        }


        //Прочитать из файла
        public void Import()
        {
            ConfigEntity.ImportAll();
        }
        //Сохранить в файл
        public void Export()
        {
            ConfigEntity.ExportAll();
        }

        public void Delete()
        {
            ConfigEntity.DeleteDirectory();
        }

    }
}
