﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using Tools.ConfigurationTool.Config.Base;

namespace Tools.ConfigurationTool.Config.Custom
{

    internal class ConfigEntity<T1, T2>
        : BaseConfigEntity<T1, ConfigParams<T1, T2>>
        where T1 : class, new()
        where T2 : class, new()
    {
        public override void SetParams(ConfigParams<T1, T2> param)
        {
            base.SetParams(param);

            if (File.Exists(Params.ConfigPath))
            {
                Import();
            }
            Export();
        }

        protected override T1 Read()
        {
            return Params
                .RW_Factory
                .Get_RW<T1, T2>(Params.ConfigPath, Params.Format, Params.Transformator)
                .Read();
        }

        protected override void Write(T1 data)
        {
            Params
                .RW_Factory
                .Get_RW<T1, T2>(Params.ConfigPath, Params.Format, Params.Transformator)
                .Write(data);
        }
    }

}
