﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.SingletonTool.Manager;

using Tools.ConfigurationTool.ConfigMultiple.Base;

namespace Tools.ConfigurationTool.ConfigMultiple.Custom
{      
    //Обеспечивате доступ к конфигу
    public class MConfigurationManager<T1, T2>
        : MConfigurationManager<T1>
        where T1: class, new()
        where T2 : class, new()
    {
        private readonly SinglethonWithParamsManager<MConfigEntity<T1, T2>, MConfigParams<T1, T2>> SinglethonManager;

        internal override IMConfigEntity<T1> ConfigEntity => SinglethonManager.Get;


        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public MConfigurationManager(MConfigParams<T1, T2> param)
        {
            SinglethonManager 
                = new SinglethonWithParamsManager<MConfigEntity<T1, T2>, MConfigParams<T1, T2>>(param);
        }

        //Для повторных обращений к конфигу
        public MConfigurationManager()
        {
            SinglethonManager
                = new SinglethonWithParamsManager<MConfigEntity<T1, T2>, MConfigParams<T1, T2>>();
        }

    }
}
