﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using RW_Tool.Core.Abstract;
using RW_Tool.DataSource.FileOrStream;
using RW_Tool.XML_BIN;

namespace Tools.ConfigurationTool.Services
{
    public class RW_Factory       
    {
        /// <summary>
        /// Получить сервис чтения/записи
        /// </summary>
        /// <typeparam name="T">Тип для приложения и для хранения</typeparam>
        public I_RW_Service<T, DS_FileOrStream> Get_RW<T>(string file, EnumFormat format)
            where T : class, new()
        => new Factory<T>().GetRW(format, new DS_File(file));


        /// <summary>
        /// Получить сервис чтения/записи
        /// </summary>
        /// <typeparam name="T1">Тип для приложения</typeparam>
        /// <typeparam name="T3">Тип для хранения</typeparam>
        /// <param name="transformator">Преобразователь для чтени/записи</param>
        public I_RW_Service<T1, DS_FileOrStream> Get_RW<T1, T3>(string file, EnumFormat format, ITransformator<T1, T3> transformator)
            where T1 : class, new()
            where T3 : class, new()
        => new Factory<T1, T3>().GetRW(format, transformator, new DS_File(file));

    }
}
