﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Diagnostics;

namespace Tools.SimpleBenchmark
{
    /// <summary>
    /// Структура для хранения результатов замера,
    /// полученных из stopwatch
    /// </summary>
    public struct WorkTime
    {
        // — возвращает общее затраченное время;
        public TimeSpan Elapsed { set; get; }
        // — возвращает общее затраченное время в миллисекундах;
        public long ElapsedMilliseconds { set; get; }
        //— возвращает общее затраченное время в тактах таймера;
        public long ElapsedTicks { set; get; }

        
        public WorkTime(Stopwatch stopwatch)
        {
            Elapsed = stopwatch.Elapsed;
            ElapsedMilliseconds = stopwatch.ElapsedMilliseconds;
            ElapsedTicks = stopwatch.ElapsedTicks;
        }


        public override string ToString()
        {
            return Elapsed + " | " + ElapsedMilliseconds + " | " + ElapsedTicks;
        }
    }
}
