﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;

using Tools.SingletonTool.Base;

namespace Tools.ConfigurationTool.ConfigMultiple.Base
{
    public abstract class BaseMConfigEntity<D, P>
        : IMConfigEntity<D>, 
        ISignlethonWithParams<P>
        where P : MConfigParams
    {
        //Параметры конфига
        public P Params { private set; get; }

        //Данные, хранимые в конфиге
        public Dictionary<string, D> Data { set; get; } = new Dictionary<string, D>();


        public virtual void SetParams(P param)
        {
            Params = param;
        }


        protected abstract D Read(string path);
        protected abstract void Write(D data, string key);


        public virtual void Export(string key)
        {
            Write(Data[key], key);
        }
        public virtual void ExportAll()
        {
            DirectoryInfo dir = Params.ConfigDirectoryInfo;

            if (Params.RecreateDirectory)
            {
                if (dir.Exists)
                {
                    dir.Delete(true);
                }
            }
            dir.Refresh();
            if (!dir.Exists)
            {
                dir.Create();
            }

            foreach (var elem in Data)
            {
                Export(elem.Key);
            }
        }

        public virtual void Import(string path)
        {
            Data.Add(
                Path.GetFileNameWithoutExtension(Path.GetFileName(path)),
                Read(path)
            );
        }
        public virtual void ImportAll()
        {
            DirectoryInfo dir = Params.ConfigDirectoryInfo;

            if (!dir.Exists)
            {
                dir.Create();
                return;
            }

            var data = dir.GetFiles();

            foreach (var elem in data)
            {
                Import(elem.FullName);
            }
        }


        public void AddAndSave(string key, D value)
        {
            Data.Add(key, value);
            Export(key);
        }
        public void RemoveAndSave(string key)
        {
            Data.Remove(key);
            var path = Params.GetPathForFile(key);
            if (File.Exists(path))
            {
                File.Delete(path);
            }
        }


        public void DeleteDirectory()
        {
            var dir = Params.ConfigDirectoryInfo;

            if (dir.Exists)
            {
                dir.Delete(true);
            }
        }

    }
}
