﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace ConfigurationTool.Serializer
{
    class BinarySerializer<T>
        : ISerializer<T>
    {

        public T Import(string file)
        {
            // передаем в конструктор тип класса
            BinaryFormatter formatter = new BinaryFormatter();

            // десериализация
            using (FileStream fs = new FileStream(file, FileMode.Open))
            {
                return (T)formatter.Deserialize(fs);
            }
        }

        public void Export(T data, string file)
        {
            // передаем в конструктор тип класса
            BinaryFormatter formatter = new BinaryFormatter();

            // получаем поток, куда будем записывать сериализованный объект
            using (FileStream fs = new FileStream(file, FileMode.Create))
            {
                formatter.Serialize(fs, data);
            }
        }


    }
}
