﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Windows.Forms;

using RW_Tool.Core.Abstract;
using RW_Tool.XML_BIN;

namespace Tools.ConfigurationTool.ConfigMultiple.Custom
{
    //Базовые параметры конфига
    public class MConfigParams<T1,T2>
    {
        //Папка, в которой будут храниться конфиги
        public string ConfigDirectory { set; get; }
        //Флаг: испоьзовать ли в пути к файлу путь к .exe приложению
        public bool UseApplicationPathPrefix { set; get; } = true;

        //Формат в котором будет храниться конфиг
        public EnumFormat Format { set; get; } = EnumFormat.XML;

        public ITransformator<T1, T2> Transformator { set; get; }

        //Пересоздавать папку при общем сохранении
        public bool RecreateDirectory { set; get; } = true;

        //Полный путь к конфигу
        public string ConfigDirectoryPath => (UseApplicationPathPrefix
            ?
             Path.Combine(Application.StartupPath, ConfigDirectory)
            :
             ConfigDirectory
            );
        public DirectoryInfo ConfigDirectoryInfo => new DirectoryInfo(ConfigDirectoryPath);

        public string GetPathForFile(string key) =>        
             Path.Combine(ConfigDirectoryPath, key + 
                (Format == EnumFormat.XML ? ".xml" : ".bin")
                );


        public MConfigParams(string ConfigDirectory, ITransformator<T1, T2> Transformator)
        {
            this.ConfigDirectory = ConfigDirectory;
            this.Transformator = Transformator;
        }
    }
}
