﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using Tools.SingletonTool;

namespace Tools.ConfigurationTool.ConfigMultiple
{      
    //Обеспечивате доступ к конфигу
    public sealed class MConfigurationManager<T>
        where T: class, new()
    {
        //Конфиг
        private MConfigEntity<T> Config => SignlethonWithParams<MConfigEntity<T>, MConfigParams>.Get();
        //Данные конфига
        public Dictionary<string, T> Data
        {
            set => Config.Data = value;
            get => Config.Data;
        }

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public MConfigurationManager(MConfigParams param)
        {
            if (!SignlethonWithParams<MConfigEntity<T>, MConfigParams>.ExistInstance)
                SignlethonWithParams<MConfigEntity<T>, MConfigParams>.Create(param);
        }

        //Для повторных обращений к конфигу
        public MConfigurationManager()
        {
            if (!SignlethonWithParams<MConfigEntity<T>, MConfigParams>.ExistInstance)
                throw new Exception("Use ConfigurationManager(ConfigParams param) first");
        }


        public void Add(string key, T value)
        {
            Data.Add(key, value);
            Config.Export(key);
        }
        public void Remove(string key)
        {
            Data.Remove(key);
            var path = Config.Params.GetPathForFile(key);
            if (File.Exists(path))
                File.Delete(path);
        }

        //Прочитать из файла
        public void Import()
        {
            Config.ImportAll();
        }
        //Сохранить в файл
        public void Export()
        {
            Config.ExportAll();
        }

        public void Delete()
        {
            var dir = Config.Params.ConfigDirectoryInfo;

            if (dir.Exists)
                dir.Delete(true);
        }
    }
}
