﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Tools.SimpleBenchmark
{

    //Результаты работы теста времени выполнения
    public class TimeTestResult : IEnumerable<WorkTime>
    {
        WorkTime[] times { get; }
        public int Length => times.Length;

        public WorkTime this[int i]
        {
            set => times[i] = value;
            get => times[i];
        }


        //Среднее для Elapsed
        public TimeSpan Elapsed_Average => new TimeSpan(0, 0, 0, 0,
            (int)(times.Sum(e => e.Elapsed.TotalMilliseconds) / times.Length));
        //Среднее для ElapsedMilliseconds
        public double ElapsedMilliseconds_Average => times.Sum(e => e.ElapsedMilliseconds) / times.Length;
        //Среднее для ElapsedTicks
        public double ElapsedTicks_Average => times.Sum(e => e.ElapsedTicks) / times.Length;


        public TimeTestResult(int TestCount)
        {
            times = new WorkTime[TestCount];
        }


        public IEnumerator<WorkTime> GetEnumerator() => times.AsEnumerable().GetEnumerator();

        IEnumerator IEnumerable.GetEnumerator() => times.GetEnumerator();

    }
}
