﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Windows.Forms;

using RW_Tool.Core.Abstract;
using RW_Tool.XML_BIN;

namespace Tools.ConfigurationTool.Config.Custom
{    
    public class ConfigParams<T1, T2>
    {
        //Имя или полный путь к файлу конфигурации
        public string ConfigFile { set; get; }
        //Флаг: испоьзовать ли в пути к файлу путь к .exe приложению
        public bool UseApplicationPathPrefix { set; get; } = true;

        //Формат в котором будет храниться конфиг
        public EnumFormat Format { set; get; } = EnumFormat.XML;

        //Трансформатор для преобразования формата из T1 в T2
        public ITransformator<T1, T2> Transformator { set; get; }

        //Путь по которому выполняются обращению к конфигу
        public string ConfigPath => (UseApplicationPathPrefix
            ?
             Path.Combine(Application.StartupPath, ConfigFile)
            :
             ConfigFile
            );


        public ConfigParams(string ConfigFile, ITransformator<T1, T2> Transformator)
        {
            this.ConfigFile = ConfigFile;
            this.Transformator = Transformator;
        }
    }
}
