﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using RW_Tool.Core.Abstract;
using RW_Tool.DataSource.FileOrStream;

using Tools.ConfigurationTool.Serializer;
using Tools.SingletonTool;

namespace Tools.ConfigurationTool.Config
{
    //Singlethon сущность конфига 
    internal class ConfigEntity<T>
        : ISignlethonWithParams<ConfigParams>
        where T : class, new()
    {
        //Параметры конфига
        internal ConfigParams Params { private set; get; }

        //Объект сериализации
        I_RW<T, DS_FileOrStream> Serializer;

        //Данные, хранимые в конфиге
        public T Data { set; get; } = new T();

        public void SetParams(ConfigParams param)
        {
            Params = param;

           Serializer = new SerializerFactory()
                .GetSerializer<T>(Params.ConfigPath, param.Format);            

            if (File.Exists(Params.ConfigPath))
                Import();
            Export();
        }

        //Прочитать файл
        public void Import()
        {
            Data = Serializer.Read();
        }
        //Сохранить в файл
        public void Export()
        {
            Serializer.Write(Data);
        }
    }

}
