﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ConfigurationTool.CustomSerializer
{
    /// <summary>
    /// Класс используесят для упрощения использования ICustomSerialazible
    /// </summary>
    /// <typeparam name="T">Тип, используемый для сериализации</typeparam>
    public abstract class BaseCustomSerialazible<T> : ICustomSerialazible
    {
        public Type SerialazibleType => typeof(T);

        void ICustomSerialazible.Import(object obj) =>
            Import((T)obj);
        object ICustomSerialazible.Export() =>
            Export();

        public abstract T Export();
        public abstract void Import(T obj);
    }
}
