﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using AutoMapper;

using RW_Tool.Core.Abstract;

namespace Test.Console
{
    public class Entity1
    {
        public int ID { set; get; }
        public string Firstname { set; get; }
        public string Secondname { set; get; }
        public DateTime Date { set; get; }


        public class Transfromator : ITransformator<Entity1, Entity2>
        {
            protected IMapper Mapper1() =>
                new MapperConfiguration(
                    cfg => cfg.CreateMap<Entity2, Entity1>()
                    .ForMember("Firstname", e1 => e1.MapFrom(el1 => el1.Name.Split(' ')[0]))
                    .ForMember("Secondname", e1 => e1.MapFrom(el1 => el1.Name.Split(' ')[1]))
                    .ForMember("Date", e1 => e1.MapFrom(el1 => DateTime.Parse(el1.Date)))
                 )
                .CreateMapper();
            protected IMapper Mapper2() =>
                new MapperConfiguration(
                    cfg => cfg.CreateMap<Entity1, Entity2>()
                    .ForMember("Name", e1 => e1.MapFrom(el1 => el1.Firstname +" "+ el1.Secondname))
                    .ForMember("Date", e1 => e1.MapFrom(el1 => el1.Date.ToShortDateString()))
                 )
                .CreateMapper();

            public Entity1 ToEntityT1(Entity2 entity)
            {
                return Mapper1().Map<Entity1>(entity);
            }
            public Entity2 ToEntityT2(Entity1 entity)
            {
                return Mapper2().Map<Entity2>(entity);
            }

        }
    }
    public class Entity2
    {
        public int ID { set; get; }
        public string Name { set; get; }
        public string Date { set; get; }
    }

}
