﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Windows.Forms;

namespace ConfigurationTool.Config
{    
    //Базовые параметры конфига
    public class ConfigParams
    {
        //Имя или полный путь к файлу конфигурации
        public string ConfigFile { set; get; }
        //Флаг: испоьзовать ли в пути к файлу путь к .exe приложению
        public bool UseApplicationPathPrefix { set; get; } = true;

        //Формат в котором будет храниться конфиг
        public EnumFormat Format { set; get; } = EnumFormat.XML;

        //Путь по которому выполняются обращению к конфигу
        public string ConfigPath => (UseApplicationPathPrefix
            ?
             Path.Combine(Application.StartupPath, ConfigFile)
            :
             ConfigFile
            );

    }
}
