﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using RW_Tool.Interface;

namespace RW_Tool
{
    public class RWI<T1,T2>
    {
        public T2 DataStorage { protected set; get; }

        public IReader<T1, T2> Reader { protected set; get; }
        public bool HaveReader => Reader != null;

        public IWriter<T1, T2> Writer { protected set; get; }
        public bool HaveWriter => Writer != null;

        public IImporter<T1, T2> Importer { protected set; get; }
        public bool HaveImporter => Importer != null;


        public RWI(T2 ds)
        {
            this.DataStorage = ds;
        }
    }
}
