﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SingletonTool
{

    //Класс выступающий в роли SinglCreate должен реализовать данный интерфейс
    public interface ISignlethonWithParams<in P>
    {
        //Аналогичен конструктору с параметром для синглтона        
        void SetParams(P param);
    }

    /// <summary>
    /// Перед обращениями необходимо создать экземпляр
    /// вызовом метода Create
    /// Позволяет передавать параметры при создании
    /// </summary>
    /// <typeparam name="T">Тип singleton</typeparam>
    /// <typeparam name="P">Параметр для конструктора объекта T</typeparam>
    public static class SignlethonWithParams<T, P>
        where T : ISignlethonWithParams<P>, new()
    {
        //Экземпляр синглтон
        private static T single;

        //Создан ли экземпляр
        public static bool ExistInstance => single != null;


        //Создает экземпляр
        public static T Create(P p)
        {
            if (ExistInstance)
                throw new Exception("SinglCreate.Create | Singlethon instance already exist");

            single = new T();
            single.SetParams(p);

            return single;
        }

        //Метод доступа к синглтону
        public static T Get()
        {
            if (!ExistInstance)
                throw new Exception("SinglCreate.Get() | Singlethon not create. Use Create(p)");

            return single;
        }

    }
}
