﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ConfigurationTool.CustomSerializer;

namespace Test_ConfigurationTool.Entities
{

    public class SubEntity
    {
        public int ID { set; get; }
        public string Name { set; get; }
    }


    public class Config2 : BaseCustomSerialazible<Config2_Serial>
    {
        public Dictionary<int, SubEntity> Dictionary { set; get; } 
            = new Dictionary<int, SubEntity>();

        public override Config2_Serial Export()
            => new Config2_Serial()
            {
                Dictionary = Dictionary
                    .Values
                    .ToList()
            };

        public override void Import(Config2_Serial obj)
        {
            Dictionary = obj
                .Dictionary
                .ToDictionary(e => e.ID);
        }
    }

    public class Config2_Serial
    {
        public List<SubEntity> Dictionary { set; get; } = new List<SubEntity>();
    }
}
